#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using gov.va.med.vbecs.DAL.VAL;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

#endregion

namespace gov.va.med.vbecs.VAL.UnitTests
{
	public class VistALinkUnitTestBinder  : IVistALinkUIBinder
	{
		private bool _checkVistALinkReconnectIfNeededCallFlag = false;

		// This method gets access & verify codes used to connect to VistALink in unit tests.
		// It's made public to unit test VistALink class.
		public virtual bool GetVistAAccessAndVerifyCodes( RemoteServerSetupAndIntroInfo serverInfo, ServerConnectionInfo serverConnectionInfo, out VistASecurityCode accessCode, out VistASecurityCode verifyCode, out bool requestVerifyCodeChangeFlag )
		{
			accessCode = UnitTestConfig.VistAAccessCode;
			verifyCode = UnitTestConfig.VistAVerifyCode;

			requestVerifyCodeChangeFlag = false;					
			
			return true;
		}
		
		// This method is required to initialize VistALink in unit tests.
		// It's made public to unit test VistALink class.
		public virtual bool GetVistANewVerifyCode( RemoteServerSetupAndIntroInfo serverInfo, ServerConnectionInfo serverConnectionInfo, out VistASecurityCode oldVerifyCode, out VistASecurityCode newVerifyCode, out VistASecurityCode newCheckVerifyCode )
		{				
			Assert.Fail( "VistALink failure: VistALink verify code used to execute unit tests is expired and must be changed. Verify code change is not supported for unit tests, please change the verify code in the app.config file of the unit test project." );

			// stub to shut up the compiler
			oldVerifyCode = newVerifyCode = newCheckVerifyCode = null;
			return false;
		}
		
		// This method is required to initialize VistALink in unit tests.
		// It's made public to unit test VistALink class.
		public virtual bool GetVistADivisionSelection( RemoteServerSetupAndIntroInfo serverInfo, ServerConnectionInfo serverConnectionInfo, DivisionInfoCollection divisionList, out DivisionInfo userSelectedDivision )
		{
			foreach( string _divisionIen in divisionList.Keys )
			{
				DivisionInfo _divisionInfo = divisionList.GetDivisionByIen( _divisionIen );

				if( _divisionInfo.Number.Trim() == UnitTestConfig.TestDivisionCode.Trim() )
				{
					userSelectedDivision = _divisionInfo;
					return true;
				}
			}

			Assert.Fail( "VistALink failure: test division is either not set in configuration file or is not among divisions available for VistA user" );

			// stub to shut up the compiler
			userSelectedDivision = null;
			return false;
		}

		// This method is required to initialize VistALink in unit tests.
		// It's made public to unit test VistALink class.
		public virtual void NotifyAboutProblem( string message ) 
		{
			// This method is not relevant for the unit test environment and
			// therefore no implementation is provided
		}

		// This method is required to initialize VistALink in unit tests.
		// It's made public to unit test VistALink class.
		public virtual bool CheckVistALinkReconnectIfNeeded()
		{
			_checkVistALinkReconnectIfNeededCallFlag = true;

			return VistALink.SilentCheckStatusReconnectIfNeeded();
		}

		// Used to indicated that CheckVistALinkReconnectIfNeeded was called. 
		// Unit tests must reset it before running test case.
		public bool CheckVistALinkReconnectIfNeeded_CallFlag
		{
			get
			{
				return _checkVistALinkReconnectIfNeededCallFlag;
			}
			set
			{
				_checkVistALinkReconnectIfNeededCallFlag = value;
			}
		}
	}
}
#endif
